/*____________________________________________________________________________
		Copyright (C) 2000 Network Associates, Inc.
        All rights reserved.

        $Id: CPath.h,v 1.10 2000/07/03 19:55:37 nryan Exp $
____________________________________________________________________________*/

#ifndef Included_CPath_h	// [
#define Included_CPath_h

#include "pgpClassesConfig.h"

#include "CString.h"
#include "UString.h"

_PGP_BEGIN

// Class CPath

class CPath : public CString
{
public:
	enum
	{
		kMaxDrives		= 26, 
		kBackSlash		= '\\', 
		kForwardSlash	= '/'
	};

public:
	CPath();
	CPath(const char *str);
	CPath(const CPath& path);

	~CPath();

	CPath&	operator=(const char *str);
	CPath&	operator=(const CPath& path);

	PGPBoolean	FindInProgress() const
	{
		return mFindHandle != INVALID_HANDLE_VALUE;
	}

	PGPBoolean	HasPlainLocalRoot() const;
	PGPBoolean	IsPlainLocalRoot() const;
	PGPBoolean	IsNetworkedPath() const;
	PGPBoolean	IsShortCut() const;
	PGPBoolean	IsUNCPath() const;

	PGPBoolean	EndsInExtension() const;

	PGPBoolean	EndsInSlash() const
	{
		return (IsSlashChar(LastChar()));
	}

	PGPBoolean	IsLegalPath() const;
	PGPBoolean	IsValidDirectory() const;
	PGPBoolean	IsValidFile() const;

	PGPBoolean	IsValidPath() const
	{
		return (IsValidDirectory() || IsValidFile());
	}

	PGPBoolean	IsCompressed() const;
	PGPBoolean	IsDriveNetworkMapped() const;
	PGPBoolean	IsReadOnly() const;
	PGPBoolean	IsDirectoryEmpty() const;

	char		GetDriveLet() const
	{
		return GetAt(0);
	}

	PGPUInt8	GetDriveNum() const
	{
		return UString::LetterToNumber(GetDriveLet());
	}

	PGPUInt64	GetFreeVolumeSpace() const;
	PGPBoolean	TestFreeVolumeSpace(PGPUInt64 bytes) const;
	PGPBoolean	SupportsLongFilenames() const;
	void		GetVolumeFileSys(CString& fileSys) const;
	void		GetVolumeRoot(CPath& volRoot) const;

	void	GetRootPart(CPath& root) const;
	void	GetDirPart(CPath& dir) const;
	void	GetDirPartSmart(CPath& dir) const;
	void	GetExtensionPart(CPath& extension) const;
	void	GetFileNamePart(CPath& filename) const;
	void	GetServerPart(CPath& server) const;
	void	GetSharePart(CPath& share) const;
	
	static PGPUInt32	GetFreeDrives(PGPBoolean ignoreAB = TRUE);

	void	AddExtension(const char *ext);
	void	RemoveExtension();
	void	GetDisplayFileName(CPath& displayName) const;

	void	EndInSlash();
	void	DontEndInSlash();
	void	FixSlashes();

	void	ConvertPathToLong();
	void	ConvertPathToShort();
	void	ResolveLocalToUNC();
	void	ResolveUNCToLocal();
	void	ResolveLoopBackPath();
	void	ResolveShortCut();

	void	Canonicalize(const char *extension = NULL);

	PGPBoolean	FindFirstFile(CPath& fileName);
	PGPBoolean	FindNextFile(CPath& fileName);
	void		FindClose();

	void	AssignCurrentDirectory();
	void	BroadcastDriveMessage(WPARAM msg) const;
	void	MakePlainLocalRoot(PGPUInt8 drive);
	void	RecurseCreateDir();

	void	Browse() const;

	static PGPBoolean	AreShowingExtensions();
	static PGPBoolean	IsSlashChar(char c)
	{
		return ((c == kBackSlash) || (c == kForwardSlash));
	}

private:
	HANDLE	mFindHandle;
};

_PGP_END

#endif	// ] Included_CPath_h
